--> Pralable
/* 
USE DB_SPORT;
GO

CREATE SCHEMA S_ADM;
GO
*/

CREATE XML SCHEMA COLLECTION XSC_PARAMS
AS
'
<xs:schema attributeFormDefault="unqualified" elementFormDefault="qualified" xmlns:xs="http://www.w3.org/2001/XMLSchema">
  <xs:element name="param">
    <xs:complexType>
      <xs:sequence>
        <xs:element type="xs:string" name="data_type"/>
        <xs:element type="xs:string" name="data_value"/>
      </xs:sequence>
    </xs:complexType>
  </xs:element>
</xs:schema>';
GO

CREATE TABLE S_ADM.T_PARAMETRE_PRM
(PRM_ID     INT IDENTITY PRIMARY KEY,
 PRM_NOM    VARCHAR(128) NOT NULL UNIQUE,
 PRM_DATA   XML (XSC_PARAMS) NOT NULL);
GO

INSERT INTO S_ADM.T_PARAMETRE_PRM VALUES
('NOM APPLICATION',
'<param>
   <data_type>string</data_type>
   <data_value>Portfolio Manager</data_value>
 </param>'),
 ('DATE CREATION',
'<param>
   <data_type>date</data_type>
   <data_value>2014-12-21</data_value>
 </param>');
GO

CREATE PRIMARY XML INDEX X_PRM_DAT_XML
   ON S_ADM.T_PARAMETRE_PRM (PRM_DATA)
   WITH (FILLFACTOR = 80);
GO

CREATE XML INDEX X_PRM_DAT_PATH_XML
   ON S_ADM.T_PARAMETRE_PRM (PRM_DATA)
   USING XML INDEX X_PRM_DAT_XML
   FOR PATH;
GO

CREATE XML INDEX X_PRM_DAT_PROPERTY_XML
   ON S_ADM.T_PARAMETRE_PRM (PRM_DATA)
   USING XML INDEX X_PRM_DAT_XML
   FOR PROPERTY
   WITH (ALLOW_PAGE_LOCKS = OFF);
GO